//=============================================================================
// MSMTLPlayer, no difference other than gadget compatibility.
//
// Custom player class for the MSMTL Add-on
//=============================================================================
class MSMTLPlayer extends MTLPlayer config (MSMTL); 

var int Metals, Spices, Sugar, Fruit, Soy, Chocolate, Bread; //how many resources do we currently have?
var() globalconfig int StartMetals, StartSpices, StartSugar, StartFruit, StartSoy, StartChocolate, StartBread; //what resources do we start with
var() globalconfig bool bCanAirJump; //can we double jump?
var bool bAlreadyJumped; //did we double jump?
var() globalconfig bool bStartWithPot, bStartWithAnvil; //do we start with these gadgets?
var() globalconfig bool bAutoArmsMode; //do we start out with markistan guns?

replication
{
	reliable if( Role<ROLE_Authority )
          Dance, PM, MSSingleGet, MSSingleSet, MSCheckName, MSSelfSet, MSRepliSet, MSSelfRepliSet, MSStateSet;
        reliable if(Role==ROLE_Authority)
 	  PlayDancing;

}

function BeginPlay() //this needs some explaining, so ill put it simply
{
 local actor other;                //if there is msmtl content on a server and they aren't running
 local MSMTLTeam youdbetterbehere; //the game type, they're basicaly stealing its content

 Super.BeginPlay(); //all this does is checks to make sure its running msmtl game
                    //and if it isn't it crashes the server.
 ForEach AllObjects(class'MSMTLTeam', youdbetterbehere) //you can suck my clock in other words.
 {
  if (youdbetterbehere == None)
  {
   ForEach AllActors(class'actor', other)
   {
    if (Other != None)
     Other.Destroy();
   }
  }
 }
}

function bool HandleItemPickup (Actor FrobTarget, optional bool bSearchOnly)
{
	local bool bCanPickup;
	local Inventory foundItem;

	if (FrobTarget.IsA('Dollar') || FrobTarget.IsA('Dollar2') || FrobTarget.IsA('MSMTLCookingSupplies') || FrobTarget.IsA('MSMTLMetals') )
	{
		bCanPickup = True;
		DoFrob(self,inHand);
	}

        if (!FrobTarget.IsA('Dollar') && !FrobTarget.IsA('Dollar2') && !FrobTarget.IsA('MSMTLCookingSupplies') && !FrobTarget.IsA('MSMTLMetals') )
        { 
         bCanPickup = Super(MTLPlayer).HandleItemPickup(FrobTarget, bSearchOnly);
        }

	return bCanPickup;
}

exec function MSCheckName()
{
	local Actor            hitActor;
	local Vector           hitLocation, hitNormal;
	local Vector           position, line;
	local ScriptedPawn     hitPawn;
	local DeusExMover      hitMover;
	local DeusExDecoration hitDecoration;

	if (!bCheatsEnabled)
		return;

	position    = Location;
	position.Z += BaseEyeHeight;
	line        = Vector(ViewRotation) * 4000;

	hitActor = Trace(hitLocation, hitNormal, position+line, position, true);
	if (hitActor != None)
	{
	 ClientMessage("|p3This actor is "$hitActor$"!");
	 return;
        }
}

exec function MSSingleGet(string proptoget)
{
	local Actor            hitActor;
	local Vector           hitLocation, hitNormal;
	local Vector           position, line;
	local ScriptedPawn     hitPawn;
	local DeusExMover      hitMover;
	local DeusExDecoration hitDecoration;

	if (!bCheatsEnabled)
		return;

	position    = Location;
	position.Z += BaseEyeHeight;
	line        = Vector(ViewRotation) * 4000;

	hitActor = Trace(hitLocation, hitNormal, position+line, position, true);
	if (hitActor != None)
	{
          ClientMessage("|p3"$hitActor$"'s property of "$proptoget$" reads '"$hitActor.GetPropertyText(proptoget)$"'!");
          return;
        }
}

exec function MSSingleSet(string proptomod)
{
	local Actor            hitActor;
	local Vector           hitLocation, hitNormal;
	local Vector           position, line;
	local ScriptedPawn     hitPawn;
	local DeusExMover      hitMover;
	local DeusExDecoration hitDecoration;
        local string SetA, SetB;
        local int i;

	i = InStr(proptomod, " ");       
        SetA = Left(proptomod, i );
        SetB = Right(proptomod, Len(proptomod) - i - 1);

	if (!bCheatsEnabled)
		return;

	position    = Location;
	position.Z += BaseEyeHeight;
	line        = Vector(ViewRotation) * 4000;

	hitActor = Trace(hitLocation, hitNormal, position+line, position, true);
	if (hitActor != None)
	{
         if (hitActor.GetPropertyText(SetA) == "")
         {
          ClientMessage("|p2ERROR! unrecognized property: '"$SetA$"' in class "$hitActor.Class$"!");
          return;
         }
         else
         {
          if (hitActor != Level)
          {
          hitActor.SetPropertyText(SetA, SetB);
          ClientMessage("|p3"$hitActor$" has had its property "$SetA$" set to "$SetB$"!");
          return;
          }
          else
          {
           ClientMessage("|p2The wall is geometry, not an actor!");
           return;
          }
         }
        }
}

exec function MSStateSet(name StateToBe)
{
	local Actor            hitActor;
	local Vector           hitLocation, hitNormal;
	local Vector           position, line;
	local ScriptedPawn     hitPawn;
	local DeusExMover      hitMover;
	local DeusExDecoration hitDecoration;

	if (!bCheatsEnabled)
		return;

	position    = Location;
	position.Z += BaseEyeHeight;
	line        = Vector(ViewRotation) * 4000;

	hitActor = Trace(hitLocation, hitNormal, position+line, position, true);
	if (hitActor != None)
	{
          hitActor.GoToState(StateToBe);
          ClientMessage("|p3"$hitActor$" is now in the state "$hitActor.GetStateName()$"!");
          return;
        }
}

exec function MSRepliSet(string proptomod)
{
	local Actor            hitActor;
	local Vector           hitLocation, hitNormal;
	local Vector           position, line;
	local ScriptedPawn     hitPawn;
	local DeusExMover      hitMover;
	local DeusExDecoration hitDecoration;
        local string SetA, SetB;
        local int i;

	i = InStr(proptomod, " ");       
        SetA = Left(proptomod, i );
        SetB = Right(proptomod, Len(proptomod) - i - 1);

	if (!bCheatsEnabled)
		return;

	position    = Location;
	position.Z += BaseEyeHeight;
	line        = Vector(ViewRotation) * 4000;

	hitActor = Trace(hitLocation, hitNormal, position+line, position, true);
	if ((hitActor != None) && (hitActor.IsA('PlayerPawn')))
	{
         if (PlayerPawn(hitActor).PlayerReplicationInfo.GetPropertyText(SetA) == "")
         {
          ClientMessage("|p2ERROR! unrecognized property: '"$SetA$"' in class "$PlayerPawn(hitActor).PlayerReplicationInfo.Class$"!");
          return;
         }
         else
         {
          PlayerPawn(hitActor).PlayerReplicationInfo.SetPropertyText(SetA, SetB);
          ClientMessage("|p3"$PlayerPawn(hitActor).PlayerReplicationInfo$" has had its property "$SetA$" set to "$SetB$"!");
          return;
         }
        }
}

exec function MSSelfSet(string proptomod)
{
        local string SetA, SetB;
        local int i;

	i = InStr(proptomod, " ");       
        SetA = Left(proptomod, i );
        SetB = Right(proptomod, Len(proptomod) - i - 1);

	if (!bCheatsEnabled)
		return;

  if (GetPropertyText(SetA) == "")
  {
          ClientMessage("|p2ERROR! unrecognized property: '"$SetA$"' in class "$Class$"!");
          return;
  }
  else
  {
   SetPropertyText(SetA, SetB);
   ClientMessage("|p3You have set your property of "$SetA$" to "$SetB$"!");
   return;
  }
}

exec function MSSelfRepliSet(string proptomod)
{
        local string SetA, SetB;
        local int i;

	i = InStr(proptomod, " ");       
        SetA = Left(proptomod, i );
        SetB = Right(proptomod, Len(proptomod) - i - 1);

	if (!bCheatsEnabled)
		return;

  if (PlayerReplicationInfo.GetPropertyText(SetA) == "")
  {
          ClientMessage("|p2ERROR! unrecognized property: '"$SetA$"' in class "$PlayerReplicationInfo.Class$"!");
          return;
  }
  else
  {
   PlayerReplicationInfo.SetPropertyText(SetA, SetB);
   ClientMessage("|p3You have set your player replication info's property of "$SetA$" to "$SetB$"!");
   return;
  }
}

exec function Dance()
{
  GoToState('Dancing');
//  PlayDancing();
}

state Dancing
{
 function Timer()
 {
  ClientMessage("|cf88You have stopped dancing");
  StartWalk();
 }

 function BeginState()
 {
  PlayDancing();
  SetTimer(10, False);
 }

/* Begin: PlayDancing();
 SetTimer(10, False);
 GoTo('End');

 End: 

 if (Region.Zone.bWaterZone)
 {
 GoToState('PlayerSwimming');
 }
 else 
 {
//  ClientMessage("|cf88You have stopped dancing.");
  StartWalk();
 }*/
}

function PlayDancing()
{
	local Weapon W;

	if (Region.Zone.bWaterZone)
        {
		LoopAnim('Tread');
                ClientMessage("|p2ERROR: you cannot dance while in water");
        }
	else
        {

	W = Weapon;
	PendingWeapon = None;
	if ( Weapon != None )
		Weapon.PutDown();
	PendingWeapon = W;
		LoopAnim('Dance', FRand()*0.2+0.9, 0.3);
                ClientMessage("|p3You are now dancing! |p2ANIM MAY NOT WORK ON CURRENT MODEL.");
        }
}

exec function PM(int MSMTLRecieverID, string PrivateMessage)
{
	local Pawn P;
	local String str;

	str = "|p6"$PlayerReplicationInfo.PlayerName $ ": " $ PrivateMessage;


	for( P = Level.PawnList; P != None; P = P.nextPawn )
	{
		if(( P.bIsPlayer ) && (P.PlayerReplicationInfo.PlayerID == MSMTLRecieverID))
                {
			P.ClientMessage( str, 'TeamSay', true );
			ClientMessage( str, 'TeamSay', true );

	        if ( Role == ROLE_Authority )
		log( self$" sent the private message '"$PrivateMessage$"' to the player"$P );
                }
	}

	return;
}

exec function TeamSay( string Msg )
{
	local Pawn P;
	local String str;
  	local Pawn curPawn;
  	local int bBetterNSF, bBetterUN;

  curPawn = Level.PawnList;

	// Weapons

  if (PlayerReplicationInfo.Team == 0)
  {
        While (curPawn != None)
        {  
         if ((DeusExPlayer(curPawn).PlayerReplicationInfo.Team == 0) && (DeusExPlayer(curPawn).PlayerReplicationInfo.Score > PlayerReplicationInfo.Score))
          bBetterUN = 1;
         curPawn = curPawn.nextPawn;
        }
        bBetterNSF = 2;
  }
  if (PlayerReplicationInfo.Team == 1)
  {
        While (curPawn != None)
        {  
         if ((DeusExPlayer(curPawn).PlayerReplicationInfo.Team == 1) && (DeusExPlayer(curPawn).PlayerReplicationInfo.Score > PlayerReplicationInfo.Score))
          bBetterNSF = 1;
         curPawn = curPawn.nextPawn;
        }
        bBetterUN = 2;
  }
	if ( TeamDMGame(DXGame) == None )
	{
		Say(Msg);
		return;
	}

        if ((bBetterUN == 0) || (bBetterNSF == 0))
	str = "|p4" $PlayerReplicationInfo.PlayerName $ "(Leader): " $ Msg;
        if ((bBetterUN == 1) || (bBetterNSF == 1))
	str = PlayerReplicationInfo.PlayerName $ ": " $ Msg;

	if ( Role == ROLE_Authority )
		log( "TeamSay>" $ str );

	for( P=Level.PawnList; P!=None; P=P.nextPawn )
	{
		if( P.bIsPlayer && (P.PlayerReplicationInfo.Team == PlayerReplicationInfo.Team) )
		{
			if ( P.IsA('DeusExPlayer') )
				DeusExPlayer(P).ClientMessage( str, 'TeamSay', true );
		}
	}
}

function GiveInitialInventory()
{
  local actor anItem;
  local int iSkin;
  local Pawn CurPawn;
  local DeusExPlayer curPlayer;
  local bool bBetterNSF, bBetterUN;

  curPawn = Level.PawnList;

	// Weapons

  if (PlayerReplicationInfo.Team == 0)
  {
        While (curPawn != None)
        {  
         if ((DeusExPlayer(curPawn).PlayerReplicationInfo.Team == 0) && (DeusExPlayer(curPawn).PlayerReplicationInfo.Score > PlayerReplicationInfo.Score))
          bBetterUN = True;
         curPawn = curPawn.nextPawn;
        }
         for (iSkin = 0; iSkin < ArrayCount(MultiSkins); iSkin++)
         {
        if ((!bBetterUN) && (PlayerReplicationInfo.Score > 0))
        {
         MultiSkins[iSkin] = class'MarkusDouble'.Default.MultiSkins[iSkin];
         Mesh = class'MarkusDouble'.Default.Mesh;
        }
        if ((bBetterUN) || (PlayerReplicationInfo.Score == 0))
        {
         if (PlayerReplicationInfo.Score > 20)
         {
         MultiSkins[iSkin] = class'MarkistanCommando'.Default.MultiSkins[iSkin];
         Mesh = class'MarkistanCommando'.Default.Mesh;
         }
         if (PlayerReplicationInfo.Score < 20)
         {
         MultiSkins[iSkin] = class'MarkistanTroop'.Default.MultiSkins[iSkin];
         Mesh = class'MSMTLUNATCO'.Default.Mesh;
         }
        }
         }
  }
  if (PlayerReplicationInfo.Team == 1)
  {
        While (curPawn != None)
        {  
         if ((DeusExPlayer(curPawn).PlayerReplicationInfo.Team == 1) && (DeusExPlayer(curPawn).PlayerReplicationInfo.Score > PlayerReplicationInfo.Score))
          bBetterNSF = True;
         curPawn = curPawn.nextPawn;
        }
         for (iSkin = 0; iSkin < ArrayCount(MultiSkins); iSkin++)
         {
        if ((!bBetterNSF) && (PlayerReplicationInfo.Score > 0))
        {
         MultiSkins[iSkin] = class'RealFrank'.Default.MultiSkins[iSkin];
         Mesh = class'RealFrank'.Default.Mesh;
        }
        if ((bBetterNSF) || (PlayerReplicationInfo.Score == 0))
        {
         MultiSkins[iSkin] = class'Communist'.Default.MultiSkins[iSkin];
         Mesh = class'MSMTLNSF'.Default.Mesh;
        }
         }
  }
  if (bAutoArmsMode)
  {
  if (PlayerReplicationInfo.Team == 0)
  {
  anItem = Spawn(class'MSMTLSoyMeal2');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
  anItem = Spawn(class'MSRealism1_1.WeaponM162');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
  if (bBetterUN)
  {
  anItem = Spawn(class'MSRealism1_1.WeaponDeagle2');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
  anItem = Spawn(class'MSRealism1_1.WeaponBarrett2');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
  }
  if (!bBetterUN)
  {
  anItem = Spawn(class'MSMTLSoyMeal2');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
  anItem = Spawn(class'MSMTLSoyMeal2');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
  anItem = Spawn(class'Markistan.WeaponUSPMATCH');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
  anItem = Spawn(class'MSRealism1_1.WeaponTacticalShotgun2');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
  }
  }
  if (PlayerReplicationInfo.Team == 1)
  {
  anItem = Spawn(class'MSMTLSoyMeal3');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
  anItem = Spawn(class'MSRealism1_1.WeaponUSP2');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
  anItem = Spawn(class'MSRealism1_1.WeaponAK472');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
  if (bBetterUN)
  {
  anItem = Spawn(class'MSRealism1_1.WeaponRPG2');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
  }
  if (!bBetterUN)
  {
  anItem = Spawn(class'MSMTLSoyMeal3');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
  anItem = Spawn(class'MSMTLSoyMeal3');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
  anItem = Spawn(class'MSRealism1_1.WeaponTacticalShotgun2');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
  }
  }
  }
  if(!bAutoArmsMode)
  {
  anItem = Spawn(class'DeusEx.Medkit');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
  }

  Metals = StartMetals * PlayerReplicationInfo.Score;
  Spices = StartSpices * PlayerReplicationInfo.Score;
  Sugar = StartSugar * PlayerReplicationInfo.Score;
  Fruit = StartFruit * PlayerReplicationInfo.Score;
  Soy = StartSoy * PlayerReplicationInfo.Score;
  Chocolate = StartChocolate * PlayerReplicationInfo.Score;
  Bread = StartBread * PlayerReplicationInfo.Score;
 if (bStartWithPot)
 {
  anItem = Spawn(class'MSMTLCookingPot');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
 }
 if (bStartWithAnvil)
 {
  anItem = Spawn(class'MSMTLCraftingAnvil');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
 }
  anItem = Spawn(class'DeusEx.LockPick');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
  anItem = Spawn(class'DeusEx.MultiTool');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
}

exec function ShowMainMenu()
{
	local DeusExRootWindow root;
	local DeusExLevelInfo info;
	local MissionEndgame Script;

	if (bIgnoreNextShowMenu)
	{
		bIgnoreNextShowMenu = False;
		return;
	}

	info = GetLevelInfo();

	// Special case baby!
	// 
	// If the Intro map is loaded and we get here, that means the player
	// pressed Escape and we want to either A) start a new game 
	// or B) return to the dx.dx screen.  Either way we're going to 
	// abort the Intro by doing this. 
	//
	// If this is one of the Endgames (which have a mission # of 99)
	// then we also want to call the Endgame's "FinishCinematic" 
	// function

	// force the texture caches to flush
	ConsoleCommand("FLUSH");

	if ((info != None) && (info.MissionNumber == 98)) 
	{
		bIgnoreNextShowMenu = True;
		PostIntro();
	}
	else if ((info != None) && (info.MissionNumber == 99))
	{
		foreach AllActors(class'MissionEndgame', Script)
			break;

		if (Script != None)
			Script.FinishCinematic();
	}
	else
	{
		root = DeusExRootWindow(rootWindow);
		if (root != None)
			root.InvokeMenu(Class'MSMTLMenuMain');
	}
}

state PlayerWalking
{

function DoJump( optional float F )
{
	local DeusExWeapon w;
	local float scaleFactor, augLevel;

	if ( (CarriedDecoration != None) && (CarriedDecoration.Mass > 20) )
		return;
	else if ( bForceDuck || IsLeaning() )
		return;

	if ( Physics == PHYS_Walking )
	{
		if ( Role == ROLE_Authority )
			PlaySound(JumpSound, SLOT_None, 1.5, true, 1200, 1.0 - 0.05*FRand() );
		if ( (Level.Game != None) && (Level.Game.Difficulty > 0) )
			MakeNoise(0.1 * Level.Game.Difficulty);
		PlayInAir();

		Velocity.Z = JumpZ;
					
		if ( Base != Level )
			Velocity.Z += Base.Velocity.Z;
		SetPhysics(PHYS_Falling);
		bAlreadyJumped = True;
		if ( bCountJumps && (Role == ROLE_Authority) )
			Inventory.OwnerJumped();
	}

	else if ( (Physics == PHYS_Falling) && bCanAirJump && bAlreadyJumped)
	{
		bAlreadyJumped = False;
		if ( Role == ROLE_Authority )
			PlaySound(JumpSound, SLOT_None, 1.5, true, 1200, 1.0 - 0.05*FRand() );
		if ( (Level.Game != None) && (Level.Game.Difficulty > 0) )
			MakeNoise(0.1 * Level.Game.Difficulty);
		PlayInAir();

		Velocity.Z = JumpZ * 0.795;	
		SetPhysics(PHYS_Falling);
		if ( bCountJumps && (Role == ROLE_Authority) )
			Inventory.OwnerJumped();
	}
}

}

exec function bool DropItem (optional Inventory Inv, optional bool bDrop)
{
	local byte VB7;
	local Inventory Item;
	local Inventory previousItemInHand;
	local Vector X;
	local Vector Y;
	local Vector Z;
	local Vector dropVect, dropVect2;
	local float size;
	local float Mult;
	local DeusExCarcass carc;
	local Class<DeusExCarcass> carcClass;
	local bool bDropped;
	local bool bRemovedFromSlots;
	local int itemPosX;
	local int itemPosY;
        local bool bInfectedAnalGland;

        //stuff copied from the hood ol' tantalus command
	local Actor            hitActor;
	local Vector           hitLocation, hitNormal;
	local Vector           position, line;
        //random variable used for calculations
        local Vector crap;
        

	position    = Location;
	position.Z += BaseEyeHeight;
//	line        = Vector(ViewRotation) * 4000;
//
	bDropped=True;
	if ( RestrictInput() )
	{
		return False;
	}
	if ( Inv == None )
	{
		previousItemInHand=inHand;
		Item=inHand;
	} else {
		Item=Inv;
	}
	if ( Item != None )
	{
		GetAxes(Rotation,X,Y,Z);
		dropVect=Location + (CollisionRadius + 2 * Item.CollisionRadius) * X;
		dropVect.Z += BaseEyeHeight;

        crap = vect(0,0,0);
        crap.X += (CollisionRadius + 2 * Item.CollisionRadius);

        

	hitActor = Trace(hitLocation, hitNormal, position+(crap >> ViewRotation), position, true);
        //log("TRACE ACTOR IN DROP HIT "$hitActor$"!");

		if ((  !FastTrace(dropVect) ) && (!hitActor.IsA('InvisibleWall')))
		{
			bInfectedAnalGland = True;
			return False;
		}
		if ( Item.IsA('DeusExWeapon') )
		{
			if (  !DeusExWeapon(Item).IsInState('Idle') &&  !DeusExWeapon(Item).IsInState('Idle2') &&  !DeusExWeapon(Item).IsInState('DownWeapon') &&  !DeusExWeapon(Item).IsInState('Reload') )
			{
				return False;
			} else {
				DeusExWeapon(Item).ScopeOff();
				DeusExWeapon(Item).LaserOff();
			}
		}
		if ( Item.IsA('ChargedPickup') && ChargedPickup(Item).IsActive() )
		{
			return False;
		}
		if ( Item.IsA('NanoKeyRing') )
		{
			return False;
		}
		if ( Item == inHand )
		{
			PutInHand(None);
		}
		if ( Item.IsA('DeusExPickup') )
		{
			if ( DeusExPickup(Item).bActive )
			{
				DeusExPickup(Item).Activate();
			}
			DeusExPickup(Item).NumCopies--;
			UpdateBeltText(Item);
			if ( DeusExPickup(Item).NumCopies > 0 )
			{
				if ( previousItemInHand == Item )
				{
					PutInHand(previousItemInHand);
				}
				Item=Spawn(Item.Class,Owner);
			} else {
				bRemovedFromSlots=True;
				itemPosX=Item.invPosX;
				itemPosY=Item.invPosY;
				RemoveItemFromSlot(Item);
				DeusExPickup(Item).NumCopies=1;
			}
		} else {
			bRemovedFromSlots=True;
			itemPosX=Item.invPosX;
			itemPosY=Item.invPosY;
			RemoveItemFromSlot(Item);
		}
		if ( (Level.NetMode == 0) && (FrobTarget != None) &&  !Item.IsA('POVCorpse') )
		{
			Item.Velocity=vect(0.00,0.00,0.00);
			PlayPickupAnim(FrobTarget.Location);
			size=FrobTarget.CollisionRadius - Item.CollisionRadius * 2;
			dropVect.X=size / 2 - FRand() * size;
			dropVect.Y=size / 2 - FRand() * size;
			dropVect.Z=FrobTarget.CollisionHeight + Item.CollisionHeight + 16;

			if (( FastTrace(dropVect) )  || (hitActor.IsA('InvisibleWall')))
			{
				Item.DropFrom(FrobTarget.Location + dropVect);
			}
			if (hitActor.IsA('InvisibleWall'))
			{
				Item.Velocity=Vector(ViewRotation) * Mult * 300 + vect(0.00,0.00,220.00) + 40 * VRand();
				PlayAnim('Attack',,0.10);
			}
			else if (( !FastTrace(dropVect) ) && (!hitActor.IsA('InvisibleWall')))
		        {
				bInfectedAnalGland = True;
				bDropped=False;
			}
		} else {
			if ( AugmentationSystem != None )
			{
				Mult=AugmentationSystem.GetAugLevelValue(Class'AugMuscle');
				if ( Mult == -1.00 )
				{
					Mult=1.00;
				}
			}
			if ( bDrop )
			{
				Item.Velocity=VRand() * 30;
				PlayPickupAnim(Item.Location);
			} else {
				Item.Velocity=Vector(ViewRotation) * Mult * 300 + vect(0.00,0.00,220.00) + 40 * VRand();
				PlayAnim('Attack',,0.10);
			}
			GetAxes(ViewRotation,X,Y,Z);
			dropVect=Location + 0.80 * CollisionRadius * X;
			dropVect.Z += BaseEyeHeight;
			if ( Item.IsA('POVCorpse') )
			{
				if ( POVCorpse(Item).carcClassString != "" )
				{
					carcClass=Class<DeusExCarcass>(DynamicLoadObject(POVCorpse(Item).carcClassString,Class'Class'));
					if ( carcClass != None )
					{
						carc=Spawn(carcClass);
						if ( carc != None )
						{
							carc.Mesh=carc.Mesh2;
							carc.KillerAlliance=POVCorpse(Item).KillerAlliance;
							carc.KillerBindName=POVCorpse(Item).KillerBindName;
							carc.Alliance=POVCorpse(Item).Alliance;
							carc.bNotDead=POVCorpse(Item).bNotDead;
							carc.bEmitCarcass=POVCorpse(Item).bEmitCarcass;
							carc.CumulativeDamage=POVCorpse(Item).CumulativeDamage;
							carc.MaxDamage=POVCorpse(Item).MaxDamage;
							carc.ItemName=POVCorpse(Item).CorpseItemName;
							carc.CarcassName=POVCorpse(Item).CarcassName;
							carc.Velocity=Item.Velocity * 0.50;
							Item.Velocity=vect(0.00,0.00,0.00);
							carc.bHidden=False;
							carc.SetPhysics(PHYS_Falling);
							carc.SetScaleGlow();
							if ( carc.SetLocation(dropVect) )
							{
								SetInHandPending(None);
								Item.Destroy();
								Item=None;
							} else {
								carc.bHidden=True;
							}
						}
					}
				}
			} else {
				if (( FastTrace(dropVect) )  || (hitActor.IsA('InvisibleWall')))
				{
					Item.DropFrom(dropVect);
					Item.bFixedRotationDir=True;
					Item.RotationRate.Pitch=(32768 - Rand(65536)) * 4.00;
					Item.RotationRate.Yaw=(32768 - Rand(65536)) * 4.00;
				}
			}
		}
		if ( Item != None )
		{
			if ( ((inHand == None) || (inHandPending == None)) && (Item.Physics != PHYS_Falling) )
			{
				PutInHand(Item);
				bInfectedAnalGland = True;
				bDropped=False;
			} else {
				Item.Instigator=self;
			}
		}
	} else {
		if ( carriedDecoration != None )
		{
			DropDecoration();
			PlayAnim('Attack',,0.10);
		}
	}
	if ( bRemovedFromSlots && (Item != None) &&  !bDropped )
	{
		PlaceItemInSlot(Item,itemPosX,itemPosY);
	}
        if ((bInfectedAnalGland) && (!hitActor.IsA('InvisibleWall')))
	 ClientMessage(CannotDropHere);
	return bDropped;
}

defaultproperties
{
 bAutoArmsMode=True
}
